import os
import re
import pandas as pd
import numpy as np

# Arquivo com os votos dos candidatos
votos = 'votacao_secao_2022_BR.csv'
print(f"Carregando: {votos}")

# Define as colunas a serem carregadas
planilhaVotos = pd.read_csv(votos, encoding="ISO-8859-1",
                            sep=";", usecols=["NR_TURNO", "SG_UF", "CD_MUNICIPIO", "NM_MUNICIPIO", "NR_ZONA", "NR_SECAO", "NM_VOTAVEL", "QT_VOTOS"])

print("Filtrando segundo turno")
segundoTurno = planilhaVotos[planilhaVotos['NR_TURNO'] == 2]


print(
    f"Total de votos incluindo brancos de nulos: {segundoTurno['QT_VOTOS'].sum():,}")

votosBolsonaro = segundoTurno[segundoTurno.NM_VOTAVEL ==
                              'JAIR MESSIAS BOLSONARO']
votosLula = segundoTurno[segundoTurno.NM_VOTAVEL ==
                         'LUIZ INÁCIO LULA DA SILVA']

# Total de votos para Bolsonaro e Lula do arquivo votacao_secao_2022_BR.csv
print(f"Total de votos para Bolsonaro: {votosBolsonaro['QT_VOTOS'].sum():,}")
print(f"Total de votos para Lula: {votosLula['QT_VOTOS'].sum():,}")

# Filtra os arquivos que possuem o número das urnas e cria novos arquivos na pasta UF
# com as colunas escolhidas em plasnilhaVotos, verifica a SG_UF, NM_MUNICIPIO, NR_ZONA e NR_SECAO
# estão presentes nas duas planilhas e então adiciona o NR_URNA_EFETIVADA nos novos arquivos
for file in os.listdir():
    if file.startswith('ceft'):
        estado = re.sub('_.*', '.csv', file.replace("ceft_2t_", ""))
        print(f"Fazendo merge: {file}")
        segundoTurnoComNumeroDaUrna = pd.merge(segundoTurno, pd.read_csv(file, encoding="ISO-8859-1", sep=";", header=0, usecols=[
            "SG_UF", "CD_MUNICIPIO", "NM_MUNICIPIO", "NR_URNA_EFETIVADA", "NR_ZONA", "NR_SECAO"]), how='inner', on=["SG_UF", "CD_MUNICIPIO", "NR_ZONA", "NR_SECAO"])

        # Filtra os números das urnas para identificar o ano de acordo com a informação de numeação/ano do TSE
        condicao = [
            (segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] >= 999500) & (
                segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] <= 1220500),
            (segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] >= 1220501) & (
                segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] <= 1345500),
            (segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] >= 1368501) & (
                segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] <= 1650000),
            (segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] >= 1650001) & (
                segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] <= 1701000),
            (segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] >= 1750000) & (
                segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] <= 1950000),
            (segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] >= 2000000) & (
                segundoTurnoComNumeroDaUrna['NR_URNA_EFETIVADA'] <= 2250000)
        ]

        ano = ['2009', '2010', '2011', '2013', '2015', '2020']

        # Cria a coluna ANO_URNA utilizando o filtro anterior
        segundoTurnoComNumeroDaUrna['ANO_URNA'] = np.select(condicao, ano)

        # Salva em arquivos .csv na pasta UF
        segundoTurnoComNumeroDaUrna.to_csv('UF/' + estado, index=False,
                                           sep=";", encoding="ISO-8859-1")
