import os
import re
import pandas as pd
import numpy as np
from fpdf import FPDF, HTMLMixin

pdf = FPDF()
pdf.add_page()


class PDF(FPDF, HTMLMixin):
    pass


html = '''
<meta charset="UTF-8">
<style>
body {
  font-family: Courier;
  font-size: 15px;
}

.conteudo {
    background-color: white;
    box-shadow: 0px 0px 6px -2px rgb(0 0 0 / 75%);
    max-width: 928px;
    margin: auto;
    margin-top: 50px;
}

table {
    border-collapse: collapse;
    margin-bottom: 40px;
    max-width: 840px;
    margin: auto;
}

tr:nth-child(odd) {
  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAADCAYAAABWKLW/AAAAHUlEQVQYV2NkgIK3b9/+ZwSxQQxhYWFGRhgDJAgA4hULytmCFnsAAAAASUVORK5CYII=);
}

tr:first-child {
  background: none;
}

th {
  padding-right: 5px;
  text-align: right;
}

th:first-child {
  border-right: 1px solid #f1f1f1;
}

th:nth-child(3) {
/*   padding-right: 40px; */
  border-right: 1px solid #f1f1f1;
}

td {
  font-style: italic;
  color: #666;
  border: 1px solid #ddd;
  padding: 3px 5px 3px 10px;
  text-align: right;
}

td:first-child {
  border-color: #f1f1f1;
  border-right: 1px solid #ddd;
  background: white;
}

tfoot td {
  border-bottom: none;
  color: black;
  font-weight: bold;
}

tfoot td:last-child {
  border-color: #f1f1f1;
}

tfoot td:first-child {
  border-color: #f1f1f1;
}

.resumo {
    border-collapse: collapse;
    margin-top: 29px;
    padding-top: 26px;
    margin-bottom: 40px;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
    padding-bottom: 44px;
}

.estado {
    border-collapse: collapse;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
    font-size: 35px;
}

.legenda {
    border-collapse: collapse;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
}
a {
    text-decoration: none;
}

.clickMunicipio {
    text-decoration: none;
    font-size: 15px;
    margin-bottom: 6px;
    color: #0e57db;
}

.info {
    padding: 34px;
    padding-top: 51px;
    line-height: 1.5;
    font-size: 16px;
    /* margin-bottom: -4px; */
}
</style>
<div class=conteudo>
<div class=info>
<b>Segundo turno das eleições presidenciais do Brasil.</b>
<br><br><b>
Veja essa página até o fim, possui informações interessantes.
<br><br></b>
Foram utilizados dados do site do TSE.
<br><br>
Nesse link é possível baixar os dados de correspondência efetivada: <a href=https://dadosabertos.tse.jus.br/dataset/resultados-2022-correspondencias-esperadas-e-efetivadas-2-turno>https://dadosabertos.tse.jus.br/dataset/resultados-2022-correspondencias-esperadas-e-efetivadas-2-turno</a>
<br><br>
Nesse link é possível baixar os dados de votação por seção eleitoral: <a href=https://cdn.tse.jus.br/estatistica/sead/odsele/votacao_secao/votacao_secao_2022_BR.zip>https://cdn.tse.jus.br/estatistica/sead/odsele/votacao_secao/votacao_secao_2022_BR.zip</a>
<br><br>
Disponibilizei esta página e os arquivos em python para fazer a análise dos dados, você pode baixá-los e adaptar para fazer suas próprias análises: <a href=segundo_turno_2022_brasil.zip>segundo_turno_2022_brasil.zip</a>
</b>
</div></div>


<div class=conteudo>
<div class=info>
<b>Urnas sem votos para um dos candidatos.</b>
<br><Br>
<a href=sem_votos_para_Bolsonaro.html>Sem votos para Bolsonaro<a>
<br><br>
<a href=sem_votos_para_Lula.html>Sem votos para Lula<a>
<br><Br>

Em alguns sites informam duas urnas a mais sem votos para Bolsonaro, porém nos dados do TSE algumas votações fora do país estão marcadas como "Sistema de apuração" e não como "Urna eletrônica", portanto não incluí na lista, pois o código de identificação está apontando para “Sistema de apuração”.
</div></div>
'''


dados = pd.concat([pd.read_csv(f, sep=";", encoding="ISO-8859-1", header=0) for f in ['UF/AC.csv', 'UF/AL.csv', 'UF/AM.csv', 'UF/AP.csv', 'UF/BA.csv', 'UF/CE.csv', 'UF/DF.csv', 'UF/ES.csv', 'UF/GO.csv', 'UF/MA.csv', 'UF/MG.csv', 'UF/MS.csv', 'UF/MT.csv',
                                                                                      'UF/PA.csv', 'UF/PB.csv', 'UF/PE.csv', 'UF/PI.csv', 'UF/PR.csv', 'UF/RJ.csv', 'UF/RN.csv', 'UF/RO.csv', 'UF/RR.csv', 'UF/RS.csv', 'UF/SC.csv', 'UF/SE.csv', 'UF/SP.csv', 'UF/TO.csv', 'UF/ZZ.csv']], ignore_index=True, axis=0)


def percentual(var1, var2):
    return var1 / (var1 + var2) * 100


votosLula = dados.loc[dados['NM_VOTAVEL'] == 'LUIZ INÁCIO LULA DA SILVA']
votosBolsonaro = dados.loc[dados['NM_VOTAVEL'] == 'JAIR MESSIAS BOLSONARO']

# print(dados)

# print(dados['QT_VOTOS'].sum())


somaVotosBolsonaro = votosBolsonaro['QT_VOTOS'].sum()
somaVotosLula = votosLula['QT_VOTOS'].sum()
somaVotosEstadoBolsonaroAntes2020 = 0
somaVotosEstadoLulaAntes2020 = 0

for estado in ['AC', 'AL', 'AM', 'AP', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MG', 'MS', 'MT', 'PA', 'PB', 'PE', 'PI', 'PR', 'RJ', 'RN', 'RO', 'RR', 'RS', 'SC', 'SE', 'SP', 'TO', 'ZZ']:

    # pdf.set_text_color(0, 20, 150)
    # pdf.set_font("Arial", size=11)
    html += f'</div><div class=conteudo>'

    texto0 = f"Estado: {estado}"
    if estado != 'AC':
        html += '</tr></table>'
    # pdf.cell(200, 6, txt=texto0, ln=1, align='L')
    print(texto0)
    # pdf.set_font("Arial", size=8)
    # pdf.set_text_color(0, 0, 0)
    if estado == 'ZZ':
        html += f'<br><div class=estado><a href=municipios_ZZ.html>Outros países</div><div class=legenda>* Não utilizaram urnas de 2020.<br><br></div></a>'
    else:
        html += f'<br><div class=estado><a href=municipios_{estado}.html>{estado} <div class=clickMunicipio>Clique aqui para ver os municipios</div></a></div><br>'
    html += f'<table width="100%"><tr><th width="5%">Modelo de urna</th><th width="5%">Votos Lula</th><th width="5%">Votos Bolsonaro</th><th width="5%">Diferença</th></th><th width="5%">Percentual Lula</th><th width="5%">Percentual Bolsonaro</th><th width="5%">Diferença Percentual</th></tr><tr>'
    for ano in ['2009', '2010', '2011', '2013', '2015', '2020']:
        votosLulaUFeAno = votosLula.loc[(votosLula['SG_UF']
                                         == estado) & (votosLula['ANO_URNA'] == int(ano))]

        votosBolsonaroUFeAno = votosBolsonaro.loc[(votosBolsonaro['SG_UF']
                                                   == estado) & (votosBolsonaro['ANO_URNA'] == int(ano))]

        somaVotosLulaUFeAno = votosLulaUFeAno['QT_VOTOS'].sum()
        somaVotosBolsonaroUFeAno = votosBolsonaroUFeAno['QT_VOTOS'].sum()
        diffVotos = somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno

        html += f'<td width="5%">{ano}</td>'

        texto1 = f"Lula com urna do ano {ano}: {somaVotosLulaUFeAno}"
        html += f'<td width="5%">{somaVotosLulaUFeAno:,}</td>'
        # pdf.cell(200, 6, txt=texto1, ln=1, align='L')
        print(texto1)

        texto2 = f"Bolsonaro com urna do ano {ano}: {somaVotosBolsonaroUFeAno}"
        html += f'<td width="5%">{somaVotosBolsonaroUFeAno:,}</td>'

        # pdf.cell(200, 6, txt=texto2, ln=1, align='L')
        print(texto2)

        if diffVotos < 0:

            texto3 = f"Mais votos para B: {abs(somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno)}"
            html += f'<td width="5%"><font color=#478d00>{abs(somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno):,} B</font></td>'

            # pdf.cell(200, 6, txt=texto3, ln=1, align='L')
            print(texto3)

        elif diffVotos == 0:

            texto4 = f"Empate {somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno}"
            html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'

            # pdf.cell(200, 6, txt=texto4, ln=1, align='L')
            print(texto4)

        elif diffVotos > 0:
            texto5 = f"Mais votos para L {somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno}"
            html += f'<td width="5%"><font color=#c10000>{somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno:,} L</font></td>'

            # pdf.cell(200, 6, txt=texto5, ln=1, align='L')
            print(texto5)

        percentualLula = percentual(
            somaVotosLulaUFeAno, somaVotosBolsonaroUFeAno)

        percentualBolsonaro = percentual(
            somaVotosBolsonaroUFeAno, somaVotosLulaUFeAno)

        html += f'<td width="5%">{percentualLula:.4f}</td>'
        html += f'<td width="5%">{percentualBolsonaro:.4f}</td>'

        if percentualLula > percentualBolsonaro:
            html += f'<td width="5%"><font color=#c10000>{(percentualLula - percentualBolsonaro):.4f} L</font></td>'
            if ano == 2020:
                diferencaPercentual2020Lado = 'Lula'
                diferencaPercentual2020 = percentualLula - percentualBolsonaro
        elif percentualLula < percentualBolsonaro:
            html += f'<td width="5%"><font color=#478d00>{(percentualBolsonaro - percentualLula):.4f} B</font></td>'
            if ano == 2020:
                diferencaPercentual2020Lado = 'Bolsonaro'
                diferencaPercentual2020 = percentualBolsonaro - percentualLula
        else:
            diferencaPercentual2020Lado = 'Nenhum'
            html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'

        if int(ano) == 2009:
            somaVotosEstadoBolsonaroAntes2020 = somaVotosBolsonaroUFeAno
            somaVotosEstadoLulaAntes2020 = somaVotosLulaUFeAno
        elif int(ano) != 2009 and int(ano) != 2020:
            somaVotosEstadoBolsonaroAntes2020 = somaVotosEstadoBolsonaroAntes2020 + \
                somaVotosBolsonaroUFeAno
            somaVotosEstadoLulaAntes2020 = somaVotosEstadoLulaAntes2020 + somaVotosLulaUFeAno
        elif int(ano) == 2020:
            somaVotosEstadoBolsonaro2020 = somaVotosBolsonaroUFeAno
            somaVotosEstadoLula2020 = somaVotosLulaUFeAno

            texto7 = f"Percentual para Lula com urna de 2020: {percentualLula}"
            # pdf.cell(200, 6, txt=texto7, ln=1, align='L')
            print(texto7)

            texto6 = f"Percentual para Bolsonaro com urna de 2020: {percentualBolsonaro}"
            # pdf.cell(200, 6, txt=texto6, ln=1, align='L')
            print(texto6)

            print('')

            html += f'</tr><tr><td width="5%">Soma das urnas de 2009 a 2015</td>'
            texto8 = f"Total de votos para Lula de antes de 2020: {somaVotosEstadoLulaAntes2020}"
            html += f'<td width="5%">{somaVotosEstadoLulaAntes2020:,}</td>'
            # pdf.cell(200, 6, txt=texto8, ln=1, align='L')
            print(texto8)

            texto9 = f"Total de votos para Bolsonaro com urnas de antes de 2020: {somaVotosEstadoBolsonaroAntes2020}"
            html += f'<td width="5%">{somaVotosEstadoBolsonaroAntes2020:,}</td>'
            # pdf.cell(200, 6, txt=texto9, ln=1, align='L')
            print(texto9)

            if somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020 < 0:
                texto12 = f"Mais votos para Bolsonaro com {abs(somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020):,} votos."
                html += f'<td width="5%"><font color=#478d00>{abs(somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020):,} B</font></td>'

            # pdf.cell(200, 6, txt=texto12, ln=1, align='L')
                print(texto12)
            elif somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020 == 0:
                texto13 = f"Empate nos votos."
                html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'
                # pdf.cell(200, 6, txt=texto13, ln=1, align='L')
                print(texto13)
            if somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020 > 0:
                texto14 = f"Mais votos para Lula com {somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020:,} votos."
                html += f'<td width="5%"><font color=#c10000>{somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020:,} L</font></td>'
                print(texto14)

            percentualLulaPre2020 = percentual(
                somaVotosEstadoLulaAntes2020, somaVotosEstadoBolsonaroAntes2020)
            percentualBolsonaroPre2020 = percentual(
                somaVotosEstadoBolsonaroAntes2020, somaVotosEstadoLulaAntes2020)

            html += f'<td width="5%">{(percentualLulaPre2020):.4f}</td>'
            html += f'<td width="5%">{(percentualBolsonaroPre2020):.4f}</td>'

            if percentualLulaPre2020 > percentualBolsonaroPre2020:
                diferencaPercentualPre2020Lado = 'Lula'
                diferencaPercentualPre2020 = percentualLulaPre2020 - percentualBolsonaroPre2020
                html += f'<td width="5%"><font color=#c10000>{(percentualLulaPre2020 - percentualBolsonaroPre2020):.4f} L</font></td>'
            elif percentualLulaPre2020 < percentualBolsonaroPre2020:
                diferencaPercentualPre2020Lado = 'Bolsonaro'
                diferencaPercentualPre2020 = percentualBolsonaroPre2020 - percentualLulaPre2020
                html += f'<td width="5%"><font color=#478d00>{(percentualBolsonaroPre2020 - percentualLulaPre2020):.4f} B</font></td>'
            else:
                diferencaPercentual2020Lado = 'Nenhum'
                html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'

            if percentualLula > percentualBolsonaro:
                diferencaPercentual2020Lado = 'Lula'
                diferencaPercentual2020 = percentualLula - percentualBolsonaro
            elif percentualLula < percentualBolsonaro:
                diferencaPercentual2020Lado = 'Bolsonaro'
                diferencaPercentual2020 = percentualBolsonaro - percentualLula
            else:
                diferencaPercentual2020Lado = 'Nenhum'

            totalDeVotosLula = somaVotosEstadoLula2020 + somaVotosEstadoLulaAntes2020
            totalDeVotosBolsonaro = somaVotosEstadoBolsonaro2020 + \
                somaVotosEstadoBolsonaroAntes2020
            html += f'</tr><tr><td width="5%">Total</td>'
            html += f'<td width="5%">{totalDeVotosLula:,}</td>'
            html += f'<td width="5%">{totalDeVotosBolsonaro:,}</td>'
            if totalDeVotosLula > totalDeVotosBolsonaro:
                html += f'<td width="5%"><font color=#c10000>{(totalDeVotosLula - totalDeVotosBolsonaro):,} L</font></td>'
            else:
                html += f'<td width="5%"><font color=#478d00>{(totalDeVotosBolsonaro - totalDeVotosLula):,} B</font></td>'

            percentualTotalLula = percentual(
                totalDeVotosLula, totalDeVotosBolsonaro)
            percentualTotalBolsonaro = percentual(
                totalDeVotosBolsonaro, totalDeVotosLula)

            html += f'<td width="5%">{percentualTotalLula:.4f}</td>'
            html += f'<td width="5%">{percentualTotalBolsonaro:.4f}</td>'

            if percentualTotalLula < percentualTotalBolsonaro:
                html += f'<td width="5%"><font color=#478d00>{(percentualTotalBolsonaro - percentualTotalLula):.4f} B</font></td>'
            elif percentualTotalLula > percentualTotalBolsonaro:
                html += f'<td width="5%"><font color=#c10000>{(percentualTotalLula - percentualTotalBolsonaro):.4f} L</font></td>'

            html += f'</tr></table><div class=resumo>'

            if diferencaPercentual2020Lado == 'Lula' and diferencaPercentualPre2020Lado == 'Lula':
                html += f'Em urnas de <b>2020 <font color=#c10000>Lula ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#c10000>Lula ganhou</font>.</b><br><br>'
                if diferencaPercentualPre2020 > diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 - diferencaPercentual2020):.4f}%</b></font>'

                if diferencaPercentualPre2020 < diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>menor</b> de votos para o Lula de: <b><font color=#478d00>{(diferencaPercentual2020 - diferencaPercentualPre2020):.4f}%</b></font>'

            if diferencaPercentual2020Lado == 'Lula' and diferencaPercentualPre2020Lado == 'Bolsonaro':
                html += f'Em urnas de <b>2020 <font color=#c10000>Lula ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#478d00>Bolsonaro ganhou</font>.</b><br><br>'
                if diferencaPercentualPre2020 < diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'
                if diferencaPercentualPre2020 > diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'

            if diferencaPercentual2020Lado == 'Bolsonaro' and diferencaPercentualPre2020Lado == 'Bolsonaro':
                html += f'Em urnas de <b>2020 <font color=#478d00>Bolsonaro ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#478d00>Bolsonaro ganhou</font>.</b><br><br>'
                if diferencaPercentualPre2020 > diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>menor</b> de votos para o Lula de: <b><font color=#478d00>{(diferencaPercentualPre2020 - diferencaPercentual2020):.4f}%</b></font>'
                if diferencaPercentualPre2020 < diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentual2020 - diferencaPercentualPre2020):.4f}%</b></font>'

            if diferencaPercentual2020Lado == 'Bolsonaro' and diferencaPercentualPre2020Lado == 'Lula':
                html += f'Em urnas de <b>2020 <font color=#478d00>Bolsonaro ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#c10000>Lula ganhou</font>.</b><br><br>'
                if diferencaPercentualPre2020 > diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'
                if diferencaPercentualPre2020 < diferencaPercentual2020:
                    html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'

            print('')
        html += '</tr><tr></div>'

    print('')
    # pdf.add_page()

arq_html = open('index.html', 'w')
arq_html.write(html)
arq_html.close()

# pdf.write_html(html)
# pdf.output("Resultado por estado.pdf")
