import os
import sys
import re
import pandas as pd
import numpy as np
from fpdf import FPDF, HTMLMixin
from pyuca import Collator


pdf = FPDF()
pdf.add_page()


class PDF(FPDF, HTMLMixin):
    pass


html = '''
<meta charset="UTF-8">
<style>
body {
  font-family: Courier;
  font-size: 15px;
}

.conteudo {
    background-color: white;
    box-shadow: 0px 0px 6px -2px rgb(0 0 0 / 75%);
    max-width: 928px;
    margin: auto;
    margin-top: 50px;
}

table {
    border-collapse: collapse;
    margin-bottom: 40px;
    max-width: 840px;
    margin: auto;
}

tr:nth-child(odd) {
  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAADCAYAAABWKLW/AAAAHUlEQVQYV2NkgIK3b9/+ZwSxQQxhYWFGRhgDJAgA4hULytmCFnsAAAAASUVORK5CYII=);
}

tr:first-child {
  background: none;
}

th {
  padding-right: 5px;
  text-align: right;
}

th:first-child {
  border-right: 1px solid #f1f1f1;
}

th:nth-child(3) {
/*   padding-right: 40px; */
  border-right: 1px solid #f1f1f1;
}

td {
  font-style: italic;
  color: #666;
  border: 1px solid #ddd;
  padding: 3px 5px 3px 10px;
  text-align: right;
}

td:first-child {
  border-color: #f1f1f1;
  border-right: 1px solid #ddd;
  background: white;
}

tfoot td {
  border-bottom: none;
  color: black;
  font-weight: bold;
}

tfoot td:last-child {
  border-color: #f1f1f1;
}

tfoot td:first-child {
  border-color: #f1f1f1;
}

.resumo {
    border-collapse: collapse;
    margin-top: 29px;
    padding-top: 26px;
    margin-bottom: 40px;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
    padding-bottom: 44px;
}

.estado {
    border-collapse: collapse;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
    font-size: 35px;
}

.legenda {
    border-collapse: collapse;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
}


element.style {
}

a {
    text-decoration: none;
}

#voltar {
    position: fixed;
    background-color: #ccfcff;
    padding: 11px;
    text-decoration: none;
    border-radius: 10px;
    box-shadow: 0px 0px 5px 0px rgb(0 0 0 / 75%);
    font-weight: bold;
    color: black;
    box-shadow: aquamarine;
    margin-top: 0;
    top: 5px;
}
</style>
'''
estadoSelecionado = sys.argv[1]

html += f'<a href=index.html> <div id=voltar>Exibindo <font color=#ff00ff>{estadoSelecionado}</font> clique aqui para ver outros estados</div></a>'

dados = pd.concat([pd.read_csv(f, sep=";", encoding="ISO-8859-1", header=0)
                  for f in ['UF/' + estadoSelecionado + '.csv']], ignore_index=True, axis=0)


def percentual(var1, var2):
    return var1 / (var1 + var2) * 100


municipiosLista = dados['NM_MUNICIPIO_x'].unique()

urna2020 = 0
urna2009a2015 = 0
urnas2020eAnteriores = 0

c = Collator()


def sort_key(item):
    return c.sort_key(str(item))  # str is somehow required


municipiosListaOrder = sorted(municipiosLista, key=sort_key)

votosLula = dados.loc[dados['NM_VOTAVEL'] == 'LUIZ INÁCIO LULA DA SILVA']
votosBolsonaro = dados.loc[dados['NM_VOTAVEL'] == 'JAIR MESSIAS BOLSONARO']

# print(municipiosLista)

# print(dados)

# print(dados['QT_VOTOS'].sum())


somaVotosBolsonaro = votosBolsonaro['QT_VOTOS'].sum()
somaVotosLula = votosLula['QT_VOTOS'].sum()
somaVotosEstadoBolsonaroAntes2020 = 0
somaVotosEstadoLulaAntes2020 = 0

for estado in municipiosListaOrder:

    # pdf.set_text_color(0, 20, 150)
    # pdf.set_font("Arial", size=11)
    html += f'</div><div class=conteudo>'

    texto0 = f"Estado: {estado}"
    if estado != 'AC':
        html += '</tr></table>'
    # pdf.cell(200, 6, txt=texto0, ln=1, align='L')
    print(texto0)
    # pdf.set_font("Arial", size=8)
    # pdf.set_text_color(0, 0, 0)

    if estado == 'ZZ':
        html += f'<br><div class=estado>Outros países</div><div class=legenda>* Não utilizaram urnas de 2020.<br><br></div>'
    else:
        html += f'<br><div class=estado>{estado}</div><br>'
    html += f'<table width="100%"><tr><th width="5%">Modelo de urna</th><th width="5%">Votos Lula</th><th width="5%">Votos Bolsonaro</th><th width="5%">Diferença</th></th><th width="5%">Percentual Lula</th><th width="5%">Percentual Bolsonaro</th><th width="5%">Diferença Percentual</th></tr><tr>'
    for ano in ['2009', '2010', '2011', '2013', '2015', '2020']:

        votosLulaUFeAno = votosLula.loc[(votosLula['NM_MUNICIPIO_x']
                                         == estado) & (votosLula['ANO_URNA'] == int(ano))]

        votosBolsonaroUFeAno = votosBolsonaro.loc[(votosBolsonaro['NM_MUNICIPIO_x']
                                                   == estado) & (votosBolsonaro['ANO_URNA'] == int(ano))]

        somaVotosLulaUFeAno = votosLulaUFeAno['QT_VOTOS'].sum()
        somaVotosBolsonaroUFeAno = votosBolsonaroUFeAno['QT_VOTOS'].sum()
        diffVotos = somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno

        html += f'<td width="5%">{ano}</td>'

        texto1 = f"Lula com urna do ano {ano}: {somaVotosLulaUFeAno}"
        html += f'<td width="5%">{somaVotosLulaUFeAno:,}</td>'
        # pdf.cell(200, 6, txt=texto1, ln=1, align='L')
        print(texto1)

        texto2 = f"Bolsonaro com urna do ano {ano}: {somaVotosBolsonaroUFeAno}"
        html += f'<td width="5%">{somaVotosBolsonaroUFeAno:,}</td>'

        # pdf.cell(200, 6, txt=texto2, ln=1, align='L')
        print(texto2)

        if diffVotos < 0:

            texto3 = f"Mais votos para B: {abs(somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno)}"
            html += f'<td width="5%"><font color=#478d00>{abs(somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno):,} B</font></td>'

            # pdf.cell(200, 6, txt=texto3, ln=1, align='L')
            print(texto3)

        elif diffVotos == 0:

            texto4 = f"Empate {somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno}"
            html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'

            # pdf.cell(200, 6, txt=texto4, ln=1, align='L')
            print(texto4)

        elif diffVotos > 0:
            texto5 = f"Mais votos para L {somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno}"
            html += f'<td width="5%"><font color=#c10000>{somaVotosLulaUFeAno - somaVotosBolsonaroUFeAno:,} L</font></td>'

            # pdf.cell(200, 6, txt=texto5, ln=1, align='L')
            print(texto5)

        percentualLula = percentual(
            somaVotosLulaUFeAno, somaVotosBolsonaroUFeAno)

        percentualBolsonaro = percentual(
            somaVotosBolsonaroUFeAno, somaVotosLulaUFeAno)

        html += f'<td width="5%">{percentualLula:.4f}</td>'
        html += f'<td width="5%">{percentualBolsonaro:.4f}</td>'

        if percentualLula > percentualBolsonaro:
            html += f'<td width="5%"><font color=#c10000>{(percentualLula - percentualBolsonaro):.4f} L</font></td>'
            if ano == 2020:
                diferencaPercentual2020Lado = 'Lula'
                diferencaPercentual2020 = percentualLula - percentualBolsonaro
        elif percentualLula < percentualBolsonaro:
            html += f'<td width="5%"><font color=#478d00>{(percentualBolsonaro - percentualLula):.4f} B</font></td>'
            if ano == 2020:
                diferencaPercentual2020Lado = 'Bolsonaro'
                diferencaPercentual2020 = percentualBolsonaro - percentualLula
        else:
            diferencaPercentual2020Lado = 'Nenhum'
            html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'

        if int(ano) == 2009:
            somaVotosEstadoBolsonaroAntes2020 = somaVotosBolsonaroUFeAno
            somaVotosEstadoLulaAntes2020 = somaVotosLulaUFeAno
        elif int(ano) != 2009 and int(ano) != 2020:
            somaVotosEstadoBolsonaroAntes2020 = somaVotosEstadoBolsonaroAntes2020 + \
                somaVotosBolsonaroUFeAno
            somaVotosEstadoLulaAntes2020 = somaVotosEstadoLulaAntes2020 + somaVotosLulaUFeAno
        elif int(ano) == 2020:
            somaVotosEstadoBolsonaro2020 = somaVotosBolsonaroUFeAno
            somaVotosEstadoLula2020 = somaVotosLulaUFeAno

            texto7 = f"Percentual para Lula com urna de 2020: {percentualLula}"
            # pdf.cell(200, 6, txt=texto7, ln=1, align='L')
            print(texto7)

            texto6 = f"Percentual para Bolsonaro com urna de 2020: {percentualBolsonaro}"
            # pdf.cell(200, 6, txt=texto6, ln=1, align='L')
            print(texto6)

            print('')

            html += f'</tr><tr><td width="5%">Soma das urnas de 2009 a 2015</td>'
            texto8 = f"Total de votos para Lula de antes de 2020: {somaVotosEstadoLulaAntes2020}"
            html += f'<td width="5%">{somaVotosEstadoLulaAntes2020:,}</td>'
            # pdf.cell(200, 6, txt=texto8, ln=1, align='L')
            print(texto8)

            texto9 = f"Total de votos para Bolsonaro com urnas de antes de 2020: {somaVotosEstadoBolsonaroAntes2020}"
            html += f'<td width="5%">{somaVotosEstadoBolsonaroAntes2020:,}</td>'
            # pdf.cell(200, 6, txt=texto9, ln=1, align='L')
            print(texto9)

            if somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020 < 0:
                texto12 = f"Mais votos para Bolsonaro com {abs(somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020):,} votos."
                html += f'<td width="5%"><font color=#478d00>{abs(somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020):,} B</font></td>'

            # pdf.cell(200, 6, txt=texto12, ln=1, align='L')
                print(texto12)
            elif somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020 == 0:
                texto13 = f"Empate nos votos."
                html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'
                # pdf.cell(200, 6, txt=texto13, ln=1, align='L')
                print(texto13)
            if somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020 > 0:
                texto14 = f"Mais votos para Lula com {somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020:,} votos."
                html += f'<td width="5%"><font color=#c10000>{somaVotosEstadoLulaAntes2020 - somaVotosEstadoBolsonaroAntes2020:,} L</font></td>'
                print(texto14)

            percentualLulaPre2020 = percentual(
                somaVotosEstadoLulaAntes2020, somaVotosEstadoBolsonaroAntes2020)
            percentualBolsonaroPre2020 = percentual(
                somaVotosEstadoBolsonaroAntes2020, somaVotosEstadoLulaAntes2020)

            html += f'<td width="5%">{(percentualLulaPre2020):.4f}</td>'
            html += f'<td width="5%">{(percentualBolsonaroPre2020):.4f}</td>'

            if percentualLulaPre2020 > percentualBolsonaroPre2020:
                diferencaPercentualPre2020Lado = 'Lula'
                diferencaPercentualPre2020 = percentualLulaPre2020 - percentualBolsonaroPre2020
                html += f'<td width="5%"><font color=#c10000>{(percentualLulaPre2020 - percentualBolsonaroPre2020):.4f} L</font></td>'
            elif percentualLulaPre2020 < percentualBolsonaroPre2020:
                diferencaPercentualPre2020Lado = 'Bolsonaro'
                diferencaPercentualPre2020 = percentualBolsonaroPre2020 - percentualLulaPre2020
                html += f'<td width="5%"><font color=#478d00>{(percentualBolsonaroPre2020 - percentualLulaPre2020):.4f} B</font></td>'
            else:
                diferencaPercentual2020Lado = 'Nenhum'
                html += f'<td width="5%"><font color=#6a6a1c>Empate</font></td>'

            if percentualLula > percentualBolsonaro:
                diferencaPercentual2020Lado = 'Lula'
                diferencaPercentual2020 = percentualLula - percentualBolsonaro
            elif percentualLula < percentualBolsonaro:
                diferencaPercentual2020Lado = 'Bolsonaro'
                diferencaPercentual2020 = percentualBolsonaro - percentualLula
            else:
                diferencaPercentual2020Lado = 'Nenhum'

            totalDeVotosLula = somaVotosEstadoLula2020 + somaVotosEstadoLulaAntes2020
            totalDeVotosBolsonaro = somaVotosEstadoBolsonaro2020 + \
                somaVotosEstadoBolsonaroAntes2020
            html += f'</tr><tr><td width="5%">Total</td>'
            html += f'<td width="5%">{totalDeVotosLula:,}</td>'
            html += f'<td width="5%">{totalDeVotosBolsonaro:,}</td>'
            if totalDeVotosLula > totalDeVotosBolsonaro:
                html += f'<td width="5%"><font color=#c10000>{(totalDeVotosLula - totalDeVotosBolsonaro):,} L</font></td>'
            else:
                html += f'<td width="5%"><font color=#478d00>{(totalDeVotosBolsonaro - totalDeVotosLula):,} B</font></td>'

            percentualTotalLula = percentual(
                totalDeVotosLula, totalDeVotosBolsonaro)
            percentualTotalBolsonaro = percentual(
                totalDeVotosBolsonaro, totalDeVotosLula)

            html += f'<td width="5%">{percentualTotalLula:.4f}</td>'
            html += f'<td width="5%">{percentualTotalBolsonaro:.4f}</td>'

            if percentualTotalLula < percentualTotalBolsonaro:
                html += f'<td width="5%"><font color=#478d00>{(percentualTotalBolsonaro - percentualTotalLula):.4f} B</font></td>'
            elif percentualTotalLula > percentualTotalBolsonaro:
                html += f'<td width="5%"><font color=#c10000>{(percentualTotalLula - percentualTotalBolsonaro):.4f} L</font></td>'

            html += f'</tr></table><div class=resumo>'

            if somaVotosEstadoLulaAntes2020 + somaVotosEstadoBolsonaroAntes2020 != 0:
                if diferencaPercentual2020Lado == 'Lula' and diferencaPercentualPre2020Lado == 'Lula':
                    html += f'Em urnas de <b>2020 <font color=#c10000>Lula ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#c10000>Lula ganhou</font>.</b><br><br>'
                    if diferencaPercentualPre2020 > diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 - diferencaPercentual2020):.4f}%</b></font>'

                    if diferencaPercentualPre2020 < diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>menor</b> de votos para o Lula de: <b><font color=#478d00>{(diferencaPercentual2020 - diferencaPercentualPre2020):.4f}%</b></font>'

                if diferencaPercentual2020Lado == 'Lula' and diferencaPercentualPre2020Lado == 'Bolsonaro':
                    html += f'Em urnas de <b>2020 <font color=#c10000>Lula ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#478d00>Bolsonaro ganhou</font>.</b><br><br>'
                    if diferencaPercentualPre2020 < diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'
                    if diferencaPercentualPre2020 > diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'

                if diferencaPercentual2020Lado == 'Bolsonaro' and diferencaPercentualPre2020Lado == 'Bolsonaro':
                    html += f'Em urnas de <b>2020 <font color=#478d00>Bolsonaro ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#478d00>Bolsonaro ganhou</font>.</b><br><br>'
                    if diferencaPercentualPre2020 > diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>menor</b> de votos para o Lula de: <b><font color=#478d00>{(diferencaPercentualPre2020 - diferencaPercentual2020):.4f}%</b></font>'
                    if diferencaPercentualPre2020 < diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentual2020 - diferencaPercentualPre2020):.4f}%</b></font>'

                if diferencaPercentual2020Lado == 'Bolsonaro' and diferencaPercentualPre2020Lado == 'Lula':
                    html += f'Em urnas de <b>2020 <font color=#478d00>Bolsonaro ganhou</b></font>.<br>Em urnas <b>antes de 2020 <font color=#c10000>Lula ganhou</font>.</b><br><br>'
                    if diferencaPercentualPre2020 > diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'
                    if diferencaPercentualPre2020 < diferencaPercentual2020:
                        html += f'A diferença entre as urnas de 2020 e antes de 2020 mostram que as urnas <b>antes de 2020</b> registraram um percentual <b>maior</b> de votos para o Lula de: <b><font color=#c10000>{(diferencaPercentualPre2020 + diferencaPercentual2020):.4f}%</b></font>'
                if somaVotosEstadoLula2020 + somaVotosEstadoBolsonaro2020 > 0:
                    urnas2020eAnteriores += 1
            else:
                html += f'<font color=#0000ff><b>Foram utilizas apenas urnas de 2020</b></font><br><br>'
                urna2020 += 1
            if somaVotosEstadoBolsonaro2020 + somaVotosEstadoLula2020 == 0:
                html += f'<font color=#961acb><b>Foram utilizadas apenas urnas de antes de 2020</b></font><br><br>'
                urna2009a2015 += 1

            print('')
        html += '</tr><tr></div>'

    print('')
    # pdf.add_page()

html += f'</div><div class=conteudo><div class=resumo>'
html += f'<div class=estado>Quantidade de municipios e distribuição de urnas</div><br><br>'
html += f'Municipios apenas com urnas antes de 2020: <b>{urna2009a2015}</b><br><br>'
html += f'Municipios apenas com urnas de 2020: <b>{urna2020}</b><br><br>'
html += f'Municipios com urnas de 2020 e de anos anteriores: <b>{urnas2020eAnteriores}</b><br><br>'
html += f'</div></div><br><br><br><br>'


arq_html = open('municipios_' + estadoSelecionado + '.html', 'w')
arq_html.write(html)
arq_html.close()


# pdf.write_html(html)
# pdf.output("Resultado por estado.pdf")
