import os
import sys
import re
import pandas as pd
import numpy as np
from fpdf import FPDF, HTMLMixin
from pyuca import Collator


pdf = FPDF()
pdf.add_page()


class PDF(FPDF, HTMLMixin):
    pass


html = '''
<meta charset="UTF-8">
<style>
body {
  font-family: Courier;
  font-size: 15px;
}

.conteudo {
    background-color: white;
    box-shadow: 0px 0px 6px -2px rgb(0 0 0 / 75%);
    max-width: 928px;
    margin: auto;
    margin-top: 50px;
    margin-bottom: 50px;
    padding-bottom: 45px;
}

table {
    border-collapse: collapse;
    margin-bottom: 40px;
    max-width: 840px;
    margin: auto;
}

tr:nth-child(odd) {
  background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAADCAYAAABWKLW/AAAAHUlEQVQYV2NkgIK3b9/+ZwSxQQxhYWFGRhgDJAgA4hULytmCFnsAAAAASUVORK5CYII=);
}

tr:first-child {
  background: none;
}

th {
  padding-right: 5px;
  text-align: right;
}

th:first-child {
  border-right: 1px solid #f1f1f1;
}

th:nth-child(3) {
/*   padding-right: 40px; */
  border-right: 1px solid #f1f1f1;
}

td {
  font-style: italic;
  color: #666;
  border: 1px solid #ddd;
  padding: 3px 5px 3px 10px;
  text-align: right;
}

td:first-child {
  border-color: #f1f1f1;
  border-right: 1px solid #ddd;
  background: white;
}

tfoot td {
  border-bottom: none;
  color: black;
  font-weight: bold;
}

tfoot td:last-child {
  border-color: #f1f1f1;
}

tfoot td:first-child {
  border-color: #f1f1f1;
}

.resumo {
    border-collapse: collapse;
    margin-top: 29px;
    padding-top: 26px;
    margin-bottom: 40px;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
    padding-bottom: 44px;
}

.estado {
    border-collapse: collapse;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
    font-size: 35px;
}

.legenda {
    border-collapse: collapse;
    max-width: 800px;
    margin: auto;
    padding-left: 22px;
}
a {
    text-decoration: none;
}

#voltar {
    position: fixed;
    background-color: #ccfcff;
    padding: 11px;
    text-decoration: none;
    border-radius: 10px;
    box-shadow: 0px 0px 5px 0px rgb(0 0 0 / 75%);
    font-weight: bold;
    color: black;
    box-shadow: aquamarine;
    margin-top: 0;
    top: 5px;
}
</style>
'''

html += f'</div><div class=conteudo>'
html += f'<a href=index.html> <div id=voltar>Exibindo urnas sem votos para Lula clique aqui para ver mais informações</div></a>'


dados = pd.concat([pd.read_csv(f, sep=";", encoding="ISO-8859-1", header=0)
                   #    for f in ['UF/RR.csv']], ignore_index=True, axis=0)
                   for f in ['UF/AC.csv', 'UF/AL.csv', 'UF/AM.csv', 'UF/AP.csv', 'UF/BA.csv', 'UF/CE.csv', 'UF/DF.csv', 'UF/ES.csv', 'UF/GO.csv', 'UF/MA.csv', 'UF/MG.csv', 'UF/MS.csv', 'UF/MT.csv', 'UF/PA.csv', 'UF/PB.csv', 'UF/PE.csv', 'UF/PI.csv', 'UF/PR.csv', 'UF/RJ.csv', 'UF/RN.csv', 'UF/RO.csv', 'UF/RR.csv', 'UF/RS.csv', 'UF/SC.csv', 'UF/SE.csv', 'UF/SP.csv', 'UF/TO.csv', 'UF/ZZ.csv']], ignore_index=True, axis=0)

votosLula = dados.loc[dados['NM_VOTAVEL'] == 'LUIZ INÁCIO LULA DA SILVA']
votosBolsonaro = dados.loc[dados['NM_VOTAVEL'] == 'JAIR MESSIAS BOLSONARO']

urnasBolsonaro = votosBolsonaro['NR_URNA_EFETIVADA']
urnasLula = votosLula['NR_URNA_EFETIVADA']

html += f'<table width="100%"><tr><th width="5%">Estado</th><th width="5%">Municipio</th><th width="5%">Zona</th><th width="5%">Seção</th></th><th width="5%">Nome</th><th width="5%">Votos</th><th width="5%">Número da urna</th></th><th width="5%">Ano da urna</tr><tr>'

numeroDeUrnas = 0

for i in urnasBolsonaro:
    if not i in votosLula['NR_URNA_EFETIVADA'].values:
        dadosUrna = dados.loc[dados['NR_URNA_EFETIVADA'] == i]
        dadosUrnaFiltro = dadosUrna.loc[dadosUrna['NM_VOTAVEL']
                                        == 'JAIR MESSIAS BOLSONARO']
        numeroDeUrnas += 1

        html += f'<td>{dadosUrnaFiltro.SG_UF.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.NM_MUNICIPIO_x.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.NR_ZONA.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.NR_SECAO.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.NM_VOTAVEL.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.QT_VOTOS.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.NR_URNA_EFETIVADA.to_string(index=False)}</td>'
        html += f'<td>{dadosUrnaFiltro.ANO_URNA.to_string(index=False)}</td>'

        print(dadosUrnaFiltro.CD_MUNICIPIO.to_string(index=False))
        print(dadosUrnaFiltro.NM_MUNICIPIO_x.to_string(index=False))
        print(dadosUrnaFiltro.NR_ZONA.to_string(index=False))
        print(dadosUrnaFiltro.NR_SECAO.to_string(index=False))
        print(dadosUrnaFiltro.NM_VOTAVEL.to_string(index=False))
        print(dadosUrnaFiltro.QT_VOTOS.to_string(index=False))
        print(dadosUrnaFiltro.NR_URNA_EFETIVADA.to_string(index=False))
        print(dadosUrnaFiltro.ANO_URNA.to_string(index=False))

        html += f'</tr>'

html += f'<div id=TotalDeUrnas>Total de urnas: {numeroDeUrnas}</div>'

arq_html = open('sem_votos_para_Lula.html', 'w')
arq_html.write(html)
arq_html.close()
